<?php
session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

// Fetch the user ID from the session
$userid = $_SESSION['userid'];

// Query to get the notifications for the logged-in user, ordered by date
$sql = "SELECT bank_name,acc_name,acc_no, branch_name,address, country FROM bank_info ORDER BY id DESC";
$stmt = $con->prepare($sql);
$stmt->execute();
$stmt->bind_result($bank_name, $acc_name, $acc_no,$branch_name, $address, $country );

// Store notifications in an array
$notifications = [];
while ($stmt->fetch()) {
    $notifications[] = [
        'bank_name' => $bank_name,
        'acc_name' => $acc_name,
        'acc_no' => $acc_no,
        'branch_name' => $branch_name,
        'address' => $address,
        'country' => $country,
    ];
}
$stmt->close();

?>

<?php include 'header-link.php' ?>

<main>

	<?php include 'top-bar.php' ?>

    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
						
							<div class="text-center">
								<i class="profile-icon fa-duotone fa-solid fa-money-check-dollar-pen"></i>
							</div>
						
                            <h6 class="card-title text-center my-3"> আমাদের ব্যাংক হিসাব সমূহ </h6>

                            <div class="offer-list" id="offerList">
                                <?php foreach ($notifications as $notification): ?>
                                    <div class="offer-card mb-3 p-4">
                                        <div class="row">
                                            <div class="col-md-12 text-left">
                                                <small > ব্যাংকের নাম - <strong>  <?php echo htmlspecialchars($notification['bank_name']); ?> </strong> </small><br>
                                                <small> অ্যাকাউন্ট নাম -  <?php echo htmlspecialchars($notification['acc_name']); ?></small><br>
                                                <small> অ্যাকাউন্ট নং - <strong> <?php echo htmlspecialchars($notification['acc_no']); ?> </strong> </small><br>
                                                <small> ব্রাঞ্চ নাম -  <?php echo htmlspecialchars($notification['branch_name']); ?></small><br>
                                                <small> পূর্ণ ঠিকানা -  <?php echo htmlspecialchars($notification['address']); ?></small><br>
                                                <small> দেশ - <?php echo htmlspecialchars($notification['country']); ?></small><br>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>


</body>
</html>
 